<?php
// app/Http/Controllers/Api/AuthController.php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Auth\Api\{SignupRequest,LoginRequest};
use App\Services\Auth\AuthServiceManager;
use App\Models\Concerns\ApiResponseTrait;
class AuthController extends Controller {
    use ApiResponseTrait;
    protected $authManager;
    public function __construct(AuthServiceManager $authManager)
    {
        $this->authManager = $authManager;
    }

    public function signup(SignupRequest $request, string $guard) {
        try {
            $service = $this->authManager->driver($guard);
            $result  = $service->signup($request->validated());
            return $this->successResponse($result, 'تم التسجيل بنجاح');
        } catch (\Exception $e) {
            return $this->errorResponse($e->getMessage());
        }
    }

    public function login(LoginRequest $request, string $guard)
    {
        try {
            $service = $this->authManager->driver($guard);
            $result  = $service->login($request->validated());
            return $this->successResponse($result, 'تم تسجيل الدخول بنجاح');
        } catch (\Exception $e) {
            return $this->errorResponse($e->getMessage());
        }
    }

    public function profile(string $guard)
    {
        try {
            $user = auth($guard)->user();
            if (!$user) {
                return $this->unauthorizedResponse('غير مصرح بالدخول');
            }

            $service = $this->authManager->driver($guard);
            $result = $service->profile($user);

            return $this->successResponse($result, 'بيانات الملف الشخصي');
        } catch (\Exception $e) {
            return $this->errorResponse($e->getMessage());
        }
    }

    public function logout(string $guard)
    {
        try {
            $service = $this->authManager->driver($guard);
            $service->logout();
            return $this->successResponse(null, 'تم تسجيل الخروج بنجاح');
        } catch (\Exception $e) {
            return $this->errorResponse($e->getMessage());
        }
    }
}
