<?php

declare(strict_types=1);

namespace App\Models;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Tymon\JWTAuth\Contracts\JWTSubject;
class Admin extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;
    protected $table = 'admins';
    protected $fillable = ['name', 'email', 'phone', 'status', 'password', 'date'];
    protected $hidden = ['remember_token',];
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'date' => 'date',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function scopeActive()
    {
        return $this->whereStatus('active')->get();
    }
}
