<?php
namespace App\Services\Auth;
use App\Contracts\AuthContract;
use InvalidArgumentException;

class AuthServiceManager
{
    protected $services = [];

    public function __construct()
    {
        $this->services = [
            'user-api' => new UserAuthService(),
            'admin-api' => new AdminAuthService(),
            'client-api' => new ClientAuthService(),
        ];
    }

    public function driver(string $guard): AuthContract
    {
        if (!isset($this->services[$guard])) {
            throw new InvalidArgumentException("Unsupported guard [$guard]");
        }

        return $this->services[$guard];
    }
}
