<?php
namespace App\Services\Auth;

use App\Contracts\AuthContract;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Http\Resources\Auth\UserResource;
class UserAuthService implements AuthContract
{
    public function signup(array $data): array
    {
        $user = User::create([
            'name'     => $data['name'],
            'email'    => $data['email'],
            'phone'    => $data['phone'],
            'password' => Hash::make($data['password']),
        ]);

        $token = JWTAuth::fromUser($user);

        return [
            'user'  => new UserResource($user),
            'token' => $token,
        ];
    }

    public function login(array $credentials): array
    {
        if (!$token = auth('user-api')->attempt($credentials)) {
            throw new \Exception('بيانات الدخول غير صحيحة');
        }

        return [
            'user'  => new UserResource(auth('user-api')->user()),
            'token' => $token,
        ];
    }

    public function profile($data): array
    {
        return [
            'user' => new UserResource($data),
        ];
    }

    public function logout(): void
    {
        auth('user-api')->logout();
    }
}
