<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::prefix('user')->middleware('auth:user-api')->group(function () {
    Route::post('profile', [Auth\AuthController::class, 'profile'])->defaults('guard', 'user-api');
    Route::post('logout', [Auth\AuthController::class, 'logout'])->defaults('guard', 'user-api');
});

Route::prefix('client')->middleware('auth:client-api')->group(function () {
    Route::get('profile', [Auth\AuthController::class, 'profile'])->defaults('guard', 'client-api');
    Route::post('logout', [Auth\AuthController::class, 'logout'])->defaults('guard', 'client-api');
});

Route::post('signup/{guard}', [Auth\AuthController::class, 'signup']);
Route::post('login/{guard}', [Auth\AuthController::class, 'login']);
