<?php
// app/Services/Auth/AdminAuthService.php

namespace App\Services\Auth;

use App\Contracts\AuthContract;
use App\Models\Admin;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Http\Resources\Auth\AdminResource;
class AdminAuthService implements AuthContract
{
    public function signup(array $data): array
    {
        $admin = Admin::create([
            'name'     => $data['name'],
            'email'    => $data['email'],
            'phone'    => $data['phone'],
            'password' => Hash::make($data['password']),
            'staus'    => 'active',
        ]);

        $token = JWTAuth::fromUser($admin);

        return [
            'admin' => new AdminResource($admin),
            'token' => $token,
        ];
    }

    public function login(array $credentials): array
    {
        if (!$token = auth('admin-api')->attempt($credentials)) {
            throw new \Exception('بيانات الدخول غير صحيحة');
        }

        return [
            'admin'  => new AdminResource(auth('admin-api')->user()),
            'token' => $token,
        ];
    }

    public function profile($data): array
    {
        return [
            'admin' => new AdminResource($data),
        ];
    }

    public function logout(): void
    {
        auth('admin-api')->logout();
    }
}
