<?php

namespace App\Services\Auth;

use App\Contracts\AuthContract;
use App\Models\Client;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;
use App\Http\Resources\Auth\ClientResource;
class ClientAuthService implements AuthContract
{
    public function signup(array $data): array
    {
        $client = Client::create([
            'name'     => $data['name'],
            'email'    => $data['email'],
            'phone'    => $data['phone'],
            'password' => Hash::make($data['password']),
        ]);

        $token = JWTAuth::fromUser($client);

        return [
            'client'  => new ClientResource($client),
            'token' => $token,
        ];
    }

    public function login(array $credentials): array
    {
        if (!$token = auth('client-api')->attempt($credentials)) {
            throw new \Exception('بيانات الدخول غير صحيحة');
        }

        return [
            'client'  => new ClientResource(auth('client-api')->user()),
            'token' => $token,
        ];
    }

    public function profile($data): array
    {
        return [
            'client' => new ClientResource($data),
        ];
    }

    public function logout(): void
    {
        auth('client-api')->logout();
    }
}
